/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.lib.varia.OrientationTools;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ConnectorIterator
implements Iterator<BlockPos> {
    @Nonnull
    private final Level world;
    @Nonnull
    private final BlockPos pos;
    private final boolean routing;
    private int facingIdx = 0;
    private BlockPos foundPos = null;

    Stream<BlockPos> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this, (long)OrientationTools.DIRECTION_VALUES.length, 16), false);
    }

    ConnectorIterator(@Nonnull Level world, @Nonnull BlockPos pos, boolean routing) {
        this.world = world;
        this.pos = pos;
        this.routing = routing;
        this.findNext();
    }

    private void findNext() {
        this.foundPos = null;
        while (this.facingIdx != -1) {
            CableColor color;
            BlockState state;
            BlockPos connectorPos = this.pos.m_142300_(OrientationTools.DIRECTION_VALUES[this.facingIdx]);
            ++this.facingIdx;
            if (this.facingIdx >= OrientationTools.DIRECTION_VALUES.length) {
                this.facingIdx = -1;
            }
            if (!((state = this.world.m_8055_(connectorPos)).m_60734_() instanceof ConnectorBlock) || (color = (CableColor)((Object)state.m_61143_(GenericCableBlock.COLOR))) == CableColor.ROUTING != this.routing) continue;
            this.foundPos = connectorPos;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.foundPos != null;
    }

    @Override
    public BlockPos next() {
        BlockPos f = this.foundPos;
        this.findNext();
        return f;
    }
}

